/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.ftp.Ftp;
import com.quantumdata.ftp.FtpConnect;
import com.quantumdata.ftp.FtpFile;
import com.quantumdata.quantumdatasdk.ChangeFileEditorDialog;
import com.quantumdata.quantumdatasdk.ChooseFileDialog;
import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.DefaultWindow;
import com.quantumdata.quantumdatasdk.ExtensionFilter;
import com.quantumdata.quantumdatasdk.QuantumDataSDK;
import com.quantumdata.quantumdatasdk.SDKFileEditorManager;
import com.quantumdata.quantumdatasdk.SDKFileEditorTab;
import com.quantumdata.quantumdatasdk.SDKOutputManager;
import com.quantumdata.quantumdatasdk.StreamGobbler;
import com.quantumdata.quantumdatasdk.TextAreaOutputStream;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.std.SocketConnection;
import com.quantumdata.std.SystemConsole;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;

public class MainScreen
extends DefaultWindow
implements ActionListener {
    private static final long serialVersionUID = 9123430910569838861L;
    private static final String sScriptFileLocationOnUnit = "/tffs0/Library/Scripts/";
    private static final String sImageFileLocationOnUnit = "/tffs0/Library/Images/";
    private static final String sWindowTitle = "Quantum Data SDK";
    private static final String sImageSubTitle = " (Image SDK)";
    private static final String sScriptSubTitle = " (Script SDK)";
    private static final String sCommandExit = "EXIT";
    private static final String sCommandNewFile = "NEW_FILE";
    private static final String sCommandNewFileWithTemplate = "NEW_FILE_WITH_TEMPLATE";
    private static final String sCommandOpenFile = "OPEN_FILE";
    private static final String sCommandCloseFile = "CLOSE_FILE";
    private static final String sCommandSaveFile = "SAVE_FILE";
    private static final String sCommandSaveFileAs = "SAVE_FILE_AS";
    private static final String sCommandCompileCurrentFile = "COMPILE_CURRENT_FILE";
    private static final String sCommandCompileAnotherFile = "COMPILE_ANOTHER_FILE";
    private static final String sCommandLoadObjectFile = "LOAD_OBJECT_FILE";
    private static final String sCommandPause = "PAUSE";
    private static final String sCommandTerminate = "TERMINATE";
    private static final String sCommandChangeEditor = "CHANGE_EDITOR";
    private static final String sCommandConnectTo = "CONNECT_TO";
    private static final String sCommandSwitchSDK = "SWITCH_SDK";
    private static final String sHeaderPrefix = "<html><body><p align=\"center\"><font face=\"book antiqua italic\"><b>";
    private static final String sHeaderSuffix = "</b></font></p></body></html>";
    private static final String sListHeaderBeginning = "<html><p align=\"right\">";
    private static final String sListHeaderMiddle = "</p><p align=\"right\"><font size=\"2\">";
    private static final String sListHeaderEnd = "</font></p></html>";
    private static JMenuItem fileTemplateMenuItem;
    private static JMenuItem loadObjectFileMenuItem;
    private static JMenuItem pauseMenuItem;
    private static JMenuItem terminateMenuItem;
    private static JMenuItem compileCurrentFileItem;
    private static JMenuItem switchSDKItem;
    private String aUnitIPAddress = QuantumDataSDK.defaultIP;
    private Container lContent = super.getContentPane();
    private static int totalFileEditorNum;
    private JSplitPane splitPane;
    private SDKFileEditorManager sdkFileEditorManager;
    private SDKOutputManager sdkOutputManager;
    private File fileToBeExecuted = null;
    private static SocketConnection con;
    private static RemoteInstrument instr;
    private JTextField jTextConnection;
    private ChooseFileDialog chooseScriptObjectFile;
    private ChooseFileDialog chooseImageObjectFile;
    private static boolean connected;
    public static boolean isScriptSDK;

    public MainScreen(ActionListener actionListener) {
        this.chooseSDK();
        this.initScreen(actionListener);
        this.chooseScriptObjectFile = new ChooseFileDialog("Choose Object File", "Choose", "Choose the object file to be loaded", 0, new ExtensionFilter(".o", "Object files (*.o)"), this, new File(ConfigData.sUserScriptFileAbsoluteLocation + "*", ""));
        this.chooseImageObjectFile = new ChooseFileDialog("Choose Object File", "Choose", "Choose the object file to be loaded", 0, new ExtensionFilter(".o", "Object files (*.o)"), this, new File(ConfigData.sUserImageFileAbsoluteLocation + "*", ""));
    }

    protected void finalize() {
        ConfigData.StoreConfig();
        this.sdkFileEditorManager = null;
        this.sdkOutputManager = null;
        con = null;
        instr = null;
    }

    private void chooseSDK() {
        Object[] objectArray = new Object[]{"Image SDK", "Script SDK", "None. Exit Application"};
        int n = JOptionPane.showOptionDialog(this, "Which SDK application do you want to launch??", "Prompt for SDK choice", 1, 3, null, objectArray, objectArray[0]);
        if (n == 0) {
            isScriptSDK = false;
        } else if (n == 1) {
            isScriptSDK = true;
        } else {
            QuantumDataSDK.ExitApp();
        }
    }

    private void initScreen(ActionListener actionListener) {
        if (isScriptSDK) {
            this.setTitle("Quantum Data SDK (Script SDK)");
        } else {
            this.setTitle("Quantum Data SDK (Image SDK)");
        }
        this.InitMenuBar(actionListener);
        this.InitComponent(actionListener);
        this.lContent.validate();
        this.pack();
        this.centerScreen();
        this.setVisible(true);
    }

    private void InitMenuBar(ActionListener actionListener) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("New...");
        jMenuItem.setMnemonic(78);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandNewFile);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        fileTemplateMenuItem = new JMenuItem("New File from Template...");
        fileTemplateMenuItem.setMnemonic(84);
        fileTemplateMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        if (isScriptSDK) {
            fileTemplateMenuItem.setEnabled(true);
        } else {
            fileTemplateMenuItem.setEnabled(false);
        }
        fileTemplateMenuItem.setActionCommand(sCommandNewFileWithTemplate);
        fileTemplateMenuItem.addActionListener(actionListener);
        jMenu.add(fileTemplateMenuItem);
        jMenuItem = new JMenuItem("Open...");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandOpenFile);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close File");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandCloseFile);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save...");
        jMenuItem.setMnemonic(83);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandSaveFile);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save as...");
        jMenuItem.setMnemonic(65);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandSaveFileAs);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu2 = new JMenu("Preference");
        jMenuItem.setMnemonic(80);
        jMenuItem.setEnabled(true);
        jMenuItem = new JMenuItem("Change Editor");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandChangeEditor);
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandExit);
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        JMenu jMenu3 = new JMenu("Compile");
        jMenu3.setMnemonic(67);
        jMenuBar.add(jMenu3);
        compileCurrentFileItem = new JMenuItem("Current File");
        compileCurrentFileItem.setMnemonic(67);
        compileCurrentFileItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        compileCurrentFileItem.setActionCommand(sCommandCompileCurrentFile);
        compileCurrentFileItem.addActionListener(actionListener);
        jMenu3.add(compileCurrentFileItem);
        jMenuItem = new JMenuItem("Another File");
        jMenuItem.setMnemonic(65);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandCompileAnotherFile);
        jMenuItem.addActionListener(actionListener);
        jMenu3.add(jMenuItem);
        JMenu jMenu4 = new JMenu("Load & Execute");
        jMenu4.setMnemonic(76);
        jMenuBar.add(jMenu4);
        loadObjectFileMenuItem = new JMenuItem("Object File");
        loadObjectFileMenuItem.setMnemonic(79);
        loadObjectFileMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        loadObjectFileMenuItem.setActionCommand(sCommandLoadObjectFile);
        loadObjectFileMenuItem.addActionListener(actionListener);
        jMenu4.add(loadObjectFileMenuItem);
        JMenu jMenu5 = new JMenu("Control");
        jMenu5.setMnemonic(84);
        jMenuBar.add(jMenu5);
        pauseMenuItem = new JMenuItem("Pause");
        pauseMenuItem.setMnemonic(80);
        pauseMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        pauseMenuItem.setActionCommand(sCommandPause);
        pauseMenuItem.addActionListener(actionListener);
        jMenu5.add(pauseMenuItem);
        terminateMenuItem = new JMenuItem("Terminate");
        terminateMenuItem.setMnemonic(84);
        terminateMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        terminateMenuItem.setActionCommand(sCommandTerminate);
        terminateMenuItem.addActionListener(actionListener);
        jMenu5.add(terminateMenuItem);
        JMenu jMenu6 = new JMenu("Connection");
        jMenu6.setMnemonic(78);
        jMenuBar.add(jMenu6);
        jMenuItem = new JMenuItem("Connect to...");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        jMenuItem.setEnabled(true);
        jMenuItem.setActionCommand(sCommandConnectTo);
        jMenuItem.addActionListener(actionListener);
        jMenu6.add(jMenuItem);
        switchSDKItem = isScriptSDK ? new JMenuItem("Switch to Image SDK") : new JMenuItem("Switch to Script SDK");
        switchSDKItem.setMnemonic(83);
        switchSDKItem.setEnabled(true);
        switchSDKItem.setActionCommand(sCommandSwitchSDK);
        switchSDKItem.addActionListener(actionListener);
        jMenuBar.add(switchSDKItem);
        this.setJMenuBar(jMenuBar);
    }

    private void InitComponent(ActionListener actionListener) {
        this.sdkFileEditorManager = new SDKFileEditorManager("SDK File Editor");
        this.sdkOutputManager = new SDKOutputManager();
        this.splitPane = new JSplitPane(0, this.sdkFileEditorManager, this.sdkOutputManager);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(400);
        this.lContent.add((Component)this.splitPane, "Center");
        this.jTextConnection = new JTextField();
        this.jTextConnection.setEditable(false);
        this.jTextConnection.setBorder(new CompoundBorder(new BevelBorder(1), new EmptyBorder(new Insets(2, 2, 2, 2))));
        this.jTextConnection.setFocusable(false);
        this.lContent.add((Component)this.jTextConnection, "South");
        this.updateCompileMenu();
        this.updateConnectionInformation();
        this.lContent.validate();
        this.pack();
        this.centerScreen();
        this.setVisible(true);
    }

    public void updateConnectionInformation() {
        if (connected) {
            this.setMenuEnabled(true);
            this.setStatusBar(String.format("Connected to %s.", instr.getConnection().getName()));
        } else {
            this.setMenuEnabled(false);
            this.setStatusBar("Not Connected");
        }
    }

    public void setStatusBar(String string) {
        this.jTextConnection.setText(string);
    }

    private void newFile() {
        if (ConfigData.sFileEditor.contentEquals("SDK Default Editor")) {
            ++totalFileEditorNum;
            this.sdkFileEditorManager.startNewFileEditor();
            this.lContent.validate();
        } else {
            try {
                Runtime.getRuntime().exec(ConfigData.sFileEditor);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void connectToUnit() {
        if (connected) {
            int n = JOptionPane.showConfirmDialog(this, "Already connected to unit: " + instr.getConnection().getName() + "!\n" + "Connect to a new unit will cause the previous connection disconnected?", "Prompt for existing connection", 0);
            if (n == 1) {
                return;
            }
            this.disconnectFromUnit();
        }
        if (this.getIPAddress()) {
            con = new SocketConnection(this.aUnitIPAddress);
            instr = new RemoteInstrument(con, new SystemConsole());
            try {
                this.reRouteOutput("Connection");
                instr.connect();
                connected = true;
                this.updateConnectionInformation();
                JOptionPane.showMessageDialog(null, "Connected to Unit: '" + this.aUnitIPAddress + "'", "Successfully Connected To Unit", 1);
            }
            catch (InstrumentException instrumentException) {
                connected = false;
                JOptionPane.showMessageDialog(null, "Error in connecting to the Unit at IP Address '" + this.aUnitIPAddress + "'", "Connection Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "You must configure a valid IP Address in the \"Config\" Menu before connecting to the Unit", "Cannot Connect To Unit", 0);
        }
    }

    private void disconnectFromUnit() {
        if (instr != null && instr.isConnected()) {
            try {
                this.reRouteOutput("Connection");
                instr.disconnect();
                connected = false;
                this.updateConnectionInformation();
                JOptionPane.showMessageDialog(null, "Disconnected from Unit: '" + this.aUnitIPAddress + "'", "Successfully disconnected from Unit", 1);
            }
            catch (Exception exception) {
                connected = true;
                JOptionPane.showMessageDialog(null, "Error in disconnecting from the Unit at IP Address '" + this.aUnitIPAddress + "'", "Disconnection Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "There is no connection to any unit!", "Disconnection Error", 0);
        }
    }

    private void reRouteOutput(String string) {
        PrintStream printStream = new PrintStream(new TextAreaOutputStream(this.sdkOutputManager.getTabTextArea(string)));
        System.setOut(printStream);
        System.setErr(printStream);
    }

    private void setMenuEnabled(boolean bl) {
        loadObjectFileMenuItem.setEnabled(bl);
        pauseMenuItem.setEnabled(bl);
        terminateMenuItem.setEnabled(bl);
    }

    private void updateCompileMenu() {
        compileCurrentFileItem.setEnabled(ConfigData.sFileEditor.contentEquals("SDK Default Editor"));
    }

    private boolean getIPAddress() {
        String string = JOptionPane.showInputDialog("Enter IP Address:  ", (Object)this.aUnitIPAddress);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            int n = 0;
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                int n2 = new Integer("" + stringTokenizer.nextToken());
                if (n2 < 0 || n2 > 255) {
                    bl = true;
                    break;
                }
                if (++n <= 4) continue;
                break;
            }
            if (!bl && n == 4) {
                this.aUnitIPAddress = string;
                return true;
            }
            JOptionPane.showMessageDialog(null, "Invalid IP Address", "Unit IP Address Not Set", 0);
            return false;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Invalid IP Address", "Unit IP Address Not Set", 0);
            return false;
        }
    }

    private void compileCurrentFile() {
        if (this.sdkFileEditorManager.validFileTab()) {
            JTabbedPane jTabbedPane = SDKFileEditorManager.getPanel();
            String string = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
            if (string.endsWith(".cpp")) {
                SDKFileEditorTab sDKFileEditorTab = this.sdkFileEditorManager.getCurrentTabHandler();
                if (sDKFileEditorTab != null) {
                    if (sDKFileEditorTab.isSaveNeeded()) {
                        Object[] objectArray = new Object[]{"Ok", "No, I want to continue editing the file"};
                        int n = JOptionPane.showOptionDialog(this, "There are unsaved changes in this file!\nDo you want to save the change first, then compile it?", "Prompt for unsaved changes", 1, 3, null, objectArray, objectArray[0]);
                        if (n == 0) {
                            this.sdkFileEditorManager.saveFile();
                        } else {
                            return;
                        }
                    }
                    this.compileFile(sDKFileEditorTab.getFile());
                }
            } else {
                JOptionPane.showMessageDialog(null, "This is NOT a valid script file!\nPlease save it to a valid file name first!", "Not a valid file name", 0);
            }
        } else {
            this.compileAnotherFile();
        }
    }

    private void compileAnotherFile() {
        File file = null;
        ChooseFileDialog chooseFileDialog = isScriptSDK ? new ChooseFileDialog("Choose Script", "Choose", "Choose the script file to be compiled", 0, new ExtensionFilter(".cpp", "Script source files (*.cpp)"), this, new File(ConfigData.sUserScriptFileAbsoluteLocation + "*", "")) : new ChooseFileDialog("Choose Image", "Choose", "Choose the image file to be compiled", 0, new ExtensionFilter(".cpp", "Image source files (*.cpp)"), this, new File(ConfigData.sUserImageFileAbsoluteLocation + "*", ""));
        file = chooseFileDialog.getFile();
        if (file != null) {
            ConfigData.updateUserFilePath(file.getAbsolutePath());
            if (ConfigData.sFileEditor.contentEquals("SDK Default Editor")) {
                this.sdkFileEditorManager.openFileByName(file, false);
            }
            this.compileFile(file);
        } else {
            JOptionPane.showMessageDialog(null, "You must choose a valid script file!", "No Script File Specified", 0);
        }
    }

    private void compileFile(File file) {
        try {
            String string = file.getCanonicalPath();
            int n = string.lastIndexOf("\\");
            int n2 = string.lastIndexOf(".");
            String string2 = string.substring(0, n2);
            JTextArea jTextArea = this.sdkOutputManager.getTabTextArea("Compile");
            jTextArea.setText("");
            String string3 = "\"" + ConfigData.sExampleAbsoluteDirectory + ConfigData.sCompileTool + "\" \"" + string2 + "\"";
            Process process = Runtime.getRuntime().exec(string3);
            StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR", jTextArea, true);
            streamGobbler.start();
            StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "OUTPUT", jTextArea, false);
            streamGobbler2.start();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void loadObjectFile() {
        if (instr != null && instr.isConnected()) {
            if (this.getObjectFileName()) {
                if (this.ftpToUnit()) {
                    this.executeFile();
                }
            } else {
                JOptionPane.showMessageDialog(null, "You must choose a valid object file!", "No Object File Specified", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "You must configure a valid IP Address in the \"Connection\" Menu before connecting to the Unit", "Cannot Connect To Unit", 0);
        }
    }

    private boolean getObjectFileName() {
        this.fileToBeExecuted = null;
        File file = null;
        file = isScriptSDK ? new File(ConfigData.sUserScriptFileAbsoluteLocation + "*", "") : new File(ConfigData.sUserImageFileAbsoluteLocation + "*", "");
        ChooseFileDialog chooseFileDialog = new ChooseFileDialog("Choose Object File", "Choose", "Choose the object file to be loaded", 0, new ExtensionFilter(".o", "Object files (*.o)"), this, file);
        this.fileToBeExecuted = chooseFileDialog.getFile();
        if (this.fileToBeExecuted != null) {
            ConfigData.updateUserFilePath(this.fileToBeExecuted.getAbsolutePath());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ftpToUnit() {
        if (instr == null) {
            JOptionPane.showMessageDialog(null, "You must connect to a valid Instrument first!", "No valid instrument connected", 0);
            return false;
        }
        if (!instr.isConnected()) {
            try {
                instr.connect();
            }
            catch (InstrumentException instrumentException) {
                JOptionPane.showMessageDialog(null, "Error in connecting to the Unit at IP Address '" + this.aUnitIPAddress + "'", "Connection Error", 0);
                return false;
            }
        }
        FtpConnect ftpConnect = new FtpConnect();
        Ftp ftp = new Ftp();
        boolean bl = false;
        try {
            SocketConnection socketConnection = (SocketConnection)instr.getConnection();
            ftpConnect.setHostName(socketConnection.getHostName());
            ftpConnect.setPassWord("");
            ftpConnect.setUserName("");
            if (ftp.connect(ftpConnect)) {
                String string;
                String string2;
                if (isScriptSDK) {
                    string2 = sScriptFileLocationOnUnit;
                    string = "Failed to create the folder to put the Script file!\n";
                } else {
                    string2 = sImageFileLocationOnUnit;
                    string = "Failed to create the folder to put the Image file!\n";
                }
                if (!ftp.cd(string2) && !ftp.mkdir(string2)) {
                    JOptionPane.showMessageDialog(null, string, "Directory Creation Error", 0);
                    boolean bl2 = false;
                    return bl2;
                }
                FtpFile ftpFile = new FtpFile(string2 + this.fileToBeExecuted.getName(), ftp);
                OutputStream outputStream = ftpFile.getOutputStream();
                FileInputStream fileInputStream = new FileInputStream(this.fileToBeExecuted);
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n);
                }
                bl = true;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            ftp.disconnect();
        }
        return bl;
    }

    private void executeFile() {
        if (isScriptSDK) {
            this.executeScriptFile();
        } else {
            this.executeImageFile();
        }
    }

    private void executeImageFile() {
        String string = "IMGP /tffs0/Library/Images/";
        InstrumentResponse instrumentResponse = instr.sendCmd(string);
        if (!instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Command \"" + string + "\" returns success: " + instrumentResponse.getResponse(), "Success", 1);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            string = "IMGL " + this.fileToBeExecuted.getName();
            instr.sendCmd(string);
            instr.sendCmd("IMGU");
        } else {
            JOptionPane.showMessageDialog(null, "Command \"" + string + "\" returns error: " + instrumentResponse.getResponse(), "Error", 0);
        }
    }

    private void executeScriptFile() {
        String string = "SCRX:LOAD " + this.fileToBeExecuted.getName();
        InstrumentResponse instrumentResponse = instr.sendCmd(string);
        if (!instrumentResponse.isError()) {
            JOptionPane.showMessageDialog(null, "Command \"" + string + "\" returns success: " + instrumentResponse.getResponse(), "Success", 1);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            instr.sendCmd("SCRX:EXEC");
        } else {
            JOptionPane.showMessageDialog(null, "Command \"" + string + "\" returns error: " + instrumentResponse.getResponse(), "Error", 0);
        }
    }

    private void pauseScript() {
    }

    private void terminateScript() {
        instr.sendCmd("SCRX:STOP");
    }

    public boolean validateData() {
        boolean bl = true;
        return bl;
    }

    public void changeFileEditor() {
        ChangeFileEditorDialog changeFileEditorDialog = new ChangeFileEditorDialog(this);
        changeFileEditorDialog.setSize(390, 140);
        changeFileEditorDialog.setLocationRelativeTo(this);
        changeFileEditorDialog.setVisible(true);
    }

    public void switchToAnotherSDK() {
        if (isScriptSDK) {
            this.setTitle("Quantum Data SDK (Image SDK)");
            fileTemplateMenuItem.setEnabled(false);
            switchSDKItem.setText("Switch to Script SDK");
            isScriptSDK = false;
        } else {
            this.setTitle("Quantum Data SDK (Script SDK)");
            fileTemplateMenuItem.setEnabled(true);
            switchSDKItem.setText("Switch to Image SDK");
            isScriptSDK = true;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandExit)) {
            this.sdkFileEditorManager.exitApp();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandNewFile)) {
            this.newFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandNewFileWithTemplate)) {
            this.sdkFileEditorManager.newFileWithTemplate();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandOpenFile)) {
            this.sdkFileEditorManager.openFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandCloseFile)) {
            this.sdkFileEditorManager.closeFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandSaveFile)) {
            this.sdkFileEditorManager.saveFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandSaveFileAs)) {
            this.sdkFileEditorManager.saveFileAs();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandCompileCurrentFile)) {
            this.compileCurrentFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandCompileAnotherFile)) {
            this.compileAnotherFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandLoadObjectFile)) {
            this.loadObjectFile();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandPause)) {
            this.getIPAddress();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandTerminate)) {
            this.terminateScript();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandChangeEditor)) {
            this.changeFileEditor();
            this.updateCompileMenu();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandConnectTo)) {
            this.connectToUnit();
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sCommandSwitchSDK)) {
            this.switchToAnotherSDK();
        }
    }

    public static final Font getArialFont(int n, int n2) {
        return new Font("Arial", n2, n);
    }

    public static final JLabel getLabel(String string, int n, int n2, boolean bl) {
        String string2 = bl ? sHeaderPrefix + string + sHeaderSuffix : string;
        JLabel jLabel = new JLabel(string2);
        jLabel.setFont(MainScreen.getArialFont(n, n2));
        return jLabel;
    }

    public static final JLabel getListLabel(String string, String string2, int n, int n2) {
        String string3 = sListHeaderBeginning + string + sListHeaderMiddle + string2 + sListHeaderEnd;
        JLabel jLabel = new JLabel(string3);
        jLabel.setFont(MainScreen.getArialFont(n, n2));
        return jLabel;
    }

    public static GridBagConstraints createGridBagConstraints(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 == 0 ? 8 : 4;
        int n7 = n5 == 22 ? 10 : 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.fill = n4;
        gridBagConstraints.insets = new Insets(0, 0, n6, n7);
        gridBagConstraints.anchor = n5;
        return gridBagConstraints;
    }

    static {
        totalFileEditorNum = 0;
        con = null;
        instr = null;
        connected = false;
    }
}

